/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TcpSocketDataTransfer;
import DE.siemens.ad.logo.dialog.CommunicationSettingPanel;
import DE.siemens.ad.logo.dialog.comp.NetworkReusablePanels;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.hardware.Logo7;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoError;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JTextArea;

public class IPConfigurePanel
extends DataInputPanel {
    private NetworkReusablePanels.SelectIPAddressPanel fSelectPanel;
    private NetworkReusablePanels.InputIPAddressPanel fAddressPanel;
    private JTextArea fMacAddress;

    public IPConfigurePanel() {
        this.setLayout(new GridBagLayout());
        this.setName(Language.getString("tool.ipConfigurePanel.title", "Configure IP Address"));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 4, 2, 4);
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.add((Component)this.getSelectPanel(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        this.add((Component)this.getAddressPanel(), constraints);
    }

    private NetworkReusablePanels.SelectIPAddressPanel getSelectPanel() {
        if (this.fSelectPanel == null) {
            this.fSelectPanel = new NetworkReusablePanels.SelectIPAddressPanel();
            this.fSelectPanel.setTitle(Language.getString("extra.ipConfigure.destinationIP", "Destination IP Address"));
        }
        return this.fSelectPanel;
    }

    private NetworkReusablePanels.InputIPAddressPanel getAddressPanel() {
        if (this.fAddressPanel == null) {
            this.fAddressPanel = new NetworkReusablePanels.InputIPAddressPanel(true);
            this.fAddressPanel.setTitle(Language.getString("tool.ipConfigurePanel.configLable", "New IP configuration"));
        }
        return this.fAddressPanel;
    }

    public boolean checkContents() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkFieldContents() {
        if (!this.getSelectPanel().checkFieldContents()) {
            return false;
        }
        if (!this.getAddressPanel().checkFieldContents()) {
            return false;
        }
        DataTransfer dt = null;
        try {
            dt = TcpSocketDataTransfer.openConnection(this.getSelectPanel().getIPAddress(), true, false);
            if (!dt.getHardware().supports("supportNetwork")) {
                new LogoError(null, "extra.ipConfigure.doNotSupportNetworkFunction", "The connected BM does not support network function.", 2, 0).display();
                boolean bl = false;
                return bl;
            }
            if (!dt.isTransmissionPossible((JComponent)this.getParent())) {
                throw new ExceptionAlreadyHandledException();
            }
            CommunicationSettingPanel.IPConfig config = this.getAddressPanel().getIPConfig();
            dt.setIPConfig(this.getIPAddressInEEprom(dt.getHardware()), config);
            dt.sendCommand(35);
            Log.println(Language.getString("extra.ipConfigure.successful", "IP configured successfully."));
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (dt != null) {
                dt.closePort();
                dt = null;
            }
        }
        return true;
    }

    private int getIPAddressInEEprom(Hardware hw) {
        if (hw instanceof Logo7) {
            return ((Logo7)hw).getIPAddressInEEprom();
        }
        throw new IllegalArgumentException();
    }
}

